# Cuadro VI.2
# Contraste de Normalidad con 
# el test de Kolmogorov-Smirnov
# y el test de Shapiro-Wilk
########################################################
# Seccin modificable por el usuario
########################################################

datos<-read.csv2("Cuadro VI.1.V.csv",enc="latin1")

# Seleccin de las variables de inters
# varInteres<-c("Zona1")
 varInteres<-c("Zona1","Zona2")

# Seleccin de categorizacin de las variables
# Si no se utilizan variables de agrupacin obligatoriamente
# se exige que se coloce varAgrupacin como NULL
# varAgrupacion<-NULL
varAgrupacion<-c("Especie")
# varAgrupacion<-c("Gnero","Especie")

# Se dibuja histograma?
graficaHist<-"si"

# Nmero de intervalos, para la grfica.
ni<-12

# Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro VI.2.V.csv"






########################################################
# Seccin que realiza el procedimiento
########################################################
# Paquetes requeridos
require(nortest)
require(MASS)
require(e1071)

combinar<-"si"

# Funcin para colapsar categoras de valores esperados
# inferiores a un lmite predeterminado.
 colapsar<-function(p1,f1,lim1=5){
  np1<-p1
  nf1<-f1
  tocollapse<-which((p1*sum(f1))<lim1)
  while(length(tocollapse)>0){
   x<-tocollapse[1]
   if (x<(length(f1)/2)){
    np1[x+1]<-p1[x]+p1[x+1]
    nf1[x+1]<-f1[x]+f1[x+1]
   }else{
    np1[x-1]<-p1[x]+p1[x-1]
    nf1[x-1]<-f1[x]+f1[x-1]
   }
   p1<-np1[-x]
   f1<-nf1[-x]
   np1<-p1
   nf1<-f1
   tocollapse<-which((p1*sum(f1))<lim1)
  }
  return(list(probs=p1,freqs=f1))  
 }

calculos2<-function(x){
 x<-x[!is.na(x)]
 if (length(x)>=3){
 # Clculo del parmetro de la distribucion utilizando el momento.
 n<-length(x)
 media<-mean(x)
 desv.est<-sd(x)
 # Prueba de Kolmogorov-Smirnov.
 pruebaks<-ks.test(x,"pnorm",mean=media,sd=desv.est)
 # Prueba de lilliefors
 pruebaKSlillie<-lillie.test(x)
 # Prueba de shapiro wilk.
 pruebaSW<-shapiro.test(x)
 # Clculo de la asimetra
 asimetria<-skewness(x)

 respuestas<-c(n,asimetria,pruebaks$statistic,pruebaks$p.value,
               pruebaKSlillie$statistic,pruebaKSlillie$p.value,
               pruebaSW$statistic,pruebaSW$p.value)
 }else return( rep(NA,11))
} 

generaGrafica2<-function(i,lista){
  x<-lista[[i]]
  x<-x[!is.na(x)]
  media<-mean(x)
  desv.est<-sd(x)
  x11()
  truehist(x,nbins=ni,sub=nombres[[i]],xlab="")
  x<-seq(min(x)*.8,max(x)*1.2,l=100)
  lines(x,dnorm(x,mean=media,sd=desv.est),lwd=1.5)
}



# Organizacin de la base de datos.
valores<-unlist(datos[,varInteres])
variables<-factor(rep(varInteres,each=dim(datos)[1]))
agrupaciones<-data.frame(datos[rep(1:dim(datos)[1],length(varInteres)),varAgrupacion])
names(agrupaciones)<-varAgrupacion
datos2<-data.frame(agrupaciones,variable=variables,valor=valores)
varAgrupacion<-c(varAgrupacion,"variable")
agrupa<-data.frame(datos2[,varAgrupacion])
if(length(varAgrupacion)==1) names(agrupa)<-varAgrupacion
listadatos2<-split(datos2$valor,as.list(agrupa),drop=TRUE)

nombres<-names(listadatos2)
r1<-t(sapply(listadatos2,calculos2))
r1<-data.frame(nombres=rownames(r1),r1)
names(r1)<-c("nombres","n","Asimetra","D de K-S","Valor-p K-S","D de K-S Lilliefors","Valor-p K-S Lilliefors","W de Shapiro","Valor-p Shapiro")
r2<-data.frame(nombres=apply(agrupa,1,paste,collapse="."),agrupa)
r2<-r2[!duplicated(r2$nombres),]
tablas<-merge(r2,r1,"nombres")

########################################################
# Seccin que muestra los resultados
########################################################

cat("Tablas de las categoras\n")
tablas

if (!is.null(ArchivodeSalida)) write.csv2(tablas,ArchivodeSalida,row.names=FALSE)


if (toupper(graficaHist)=="SI"){
 sapply(1:length(listadatos2),generaGrafica2,listadatos2)  
}










